using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hive.adkit.daro
{
	public class AdKitRewarded
	{
		public AdKitRewarded(string adUnitId, EventHandlers handler)
		{
			internalInit(adUnitId, handler);
		}

		~AdKitRewarded() {
			//
		}

		private string adKey = "";

	#if UNITY_ANDROID && !UNITY_EDITOR
		
		private string adKitPluginClass = "com.hive.adkit.daro.plugin.AdKitUnityRewarded";
		private AndroidJavaObject adKitPlugin = null;

		private void internalInit(string adUnitId, EventHandlers handler) {
			AdKitLogger.d("AdKitRewarded Init "+adUnitId);

			using (var unityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer"))
			using (var currentActivity = unityPlayer.GetStatic<AndroidJavaObject>("currentActivity")) {

				adKitPlugin = new AndroidJavaObject(adKitPluginClass);
				if(adKitPlugin != null) {
					adKey = adUnitId;
					adKitPlugin.Call("initialize", currentActivity, adUnitId);
					AdKitCallbackManager.Instance.RegisterCallbackHandler(adUnitId, handler);
				} else {
					AdKitLogger.e("Failed to create AndroidJavaObject for " + adKitPluginClass);
				}
			}
		}

		public void Load(string adPlacementInfo) {

			if(adKitPlugin == null) {
				AdKitLogger.e("Load() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}
		
			AdKitLogger.d("AdKitRewarded Load");
			adKitPlugin.Call("load", adPlacementInfo);
		}

		public void Show(string adPlacementInfo) {

			if(adKitPlugin == null) {
				AdKitLogger.e("Show() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}
			
			AdKitLogger.d("AdKitRewarded Show");
			adKitPlugin.Call("show", adPlacementInfo);
		}

		public void Destroy() {

			if(adKitPlugin == null) {
				AdKitLogger.e("Destroy() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}
		
			AdKitLogger.d("AdKitRewarded Destroy");
			adKitPlugin.Call("destroy");
			AdKitCallbackManager.Instance.UnregisterCallbackHandler(adKey);
		}

		public bool IsLoaded() {

			if(adKitPlugin == null) {
				AdKitLogger.e("IsLoaded() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return false;
			}
			
			bool isLoaded = adKitPlugin.Call<bool>("isLoaded");
			return isLoaded;
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void AdKit_RewardVideoInitialize(string adUnitId);

		[DllImport("__Internal")]
		private static extern void AdKit_RewardVideoLoad(string adUnitId, string adPlacementInfo);

		[DllImport("__Internal")]
		private static extern void AdKit_RewardVideoShow(string adUnitId, string adPlacementInfo);

		[DllImport("__Internal")]
		private static extern void AdKit_RewardVideoDestroy(string adUnitId);

		[DllImport("__Internal")]
		private static extern bool AdKit_RewardVideoIsLoaded(string adUnitId);

		private void internalInit(string adUnitId, EventHandlers handler) {
			AdKitLogger.d("AdKitRewarded Init "+adUnitId);
			adKey = adUnitId;
			
			AdKitCallbackManager.Instance.RegisterCallbackHandler(adUnitId, handler);

			AdKit_RewardVideoInitialize(adUnitId);
		}

		public void Load(string adPlacementInfo) {
			AdKitLogger.d("AdKitRewarded Load");
			AdKit_RewardVideoLoad(adKey, adPlacementInfo);
		}

		public void Show(string adPlacementInfo) {
			AdKitLogger.d("AdKitRewarded Show");
			AdKit_RewardVideoShow(adKey, adPlacementInfo);
		}

		public void Destroy() {
			AdKitLogger.d("AdKitRewarded Destroy");
			AdKit_RewardVideoDestroy(adKey);
			AdKitCallbackManager.Instance.UnregisterCallbackHandler(adKey);
		}

		public bool IsLoaded() {
			return AdKit_RewardVideoIsLoaded(adKey);
		}
	#else

		private void internalInit(string adUnitId, EventHandlers handler) {
			
		}

		public void Load(string adPlacementInfo) {
			
		}			

		public void Show(string adPlacementInfo) {
			
		}

		public void Destroy() {
			
		}

		public bool IsLoaded() {
			return false;
		}
	#endif
		
	}
}